function bm_edit_app_view3d_callback(obj, hObj)
% processing callback of bm_edit_app_view3d.
% [IN]
%     obj : bm_edit_app_view3d object
%    hObj : action component handle
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('hObj', 'var'), error('hObj is a required parameter.'); end

%
% --- Main Procedure
%
H = guihandles(obj.h);

switch(hObj)
    case H.model_listbox
        % set current axes to selected axes
        set(gcf, 'CurrentAxes', H.selected_axes);
        cla(H.selected_axes);
        % get patch handle
        if length(obj.patch_handles) <= 0, return; end
        selected = get(H.model_listbox, 'Value');
        patch_h = obj.patch_handles(selected);
        % copy patch from main axes to selected axes
        new_patch_h = copyobj(patch_h, H.selected_axes);
        % view setting
        alpha(new_patch_h, 1);
        lighting phong;
        material dull;
        axis equal;
        axis off;
        camlight(-60,0);
        camlight(60,0);
        camlight(180,0);
        set(H.selected_axes, 'View', get(H.model_axes, 'View'));
        xlim(H.selected_axes, xlim(H.model_axes));
        ylim(H.selected_axes, ylim(H.model_axes));
        zlim(H.selected_axes, zlim(H.model_axes));
        % show current alpha popup
        alpha_val = get(patch_h, 'FaceAlpha');
        contents = get(H.tranceparent_popup, 'String');
        alpha_val_list = zeros(length(contents), 1);
        for k=1:length(contents)
            alpha_val_list(k) = str2num(contents{k});
        end
        ix = find(alpha_val_list == alpha_val);
        set(H.tranceparent_popup, 'Value', ix);
    case H.color_push
        % get change object 
        selected = get(H.model_listbox, 'Value');
        patch_h = obj.patch_handles(selected);
        % select new color
        C = get(patch_h, 'FaceColor');
        C = uisetcolor(C);
        % change color
        if length(C) == 1 && C == 0
        else
            set(patch_h, 'FaceColor', C);
            bm_edit_app_view3d_callback(obj, H.model_listbox);
        end
    case H.tranceparent_popup
        % get change object 
        selected = get(H.model_listbox, 'Value');
        patch_h = obj.patch_handles(selected);
        % select new transparent
        contents = get(H.tranceparent_popup, 'String');
        Value = get(H.tranceparent_popup, 'Value');
        tranceparent = sscanf(contents{Value}, '%f');
        % change tranceparent
        alpha(patch_h, tranceparent);
end

rotate3d(H.model_axes, 'on');

guidata(obj.h, obj);
