function view2d = bm_edit_app_view2d_display_brain(...
                                  view2d, display_factor, view_setting2d)
% display 2D brain.
% [USAGE]
%    obj = bm_edit_app_view2d_display_brain(...
%                           <view2d>, <display_factor>, <view_setting2d>);
% [IN]
%    view2d          : bm_edit_app_view2d object
%    display_factor  : display_factor object
%    view_setting2d  : property for plot
% [OUT]
%    view2d : update view2d object
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('view2d', 'var'), error('view2d is a required parameter.'); end
if ~exist('display_factor', 'var')
    error('display_factor is a required parameter.');
end
if ~exist('view_setting2d', 'var')
    error('view_setting2d is a required parameter.');
end

%
% --- Main Procedure
%
evalin('base', 'clear avw');

display_factor = vb_display_factor_set_element_color(...
                    display_factor, ...
                    bm_view_parm2d_get_color(view_setting2d));

analyze_file = bm_view_parm2d_get_analyze_file(view_setting2d);
if ~ishandle(view2d.h)
    avw = avw_read_ras(analyze_file);
    avw.display_factor = display_factor;
    vb_mri_point_select(avw, '', 'init'); % display delegate
    view2d.h = gcf;
    set(view2d.h, 'Unit', 'normalized');
    set(view2d.h, 'Position', [0.35, 0.2, 0.6, 0.6]);
else
    % Update display
    figure(view2d.h);
    set(0, 'CurrentFigure', view2d.h);
    AVWVIEW = get(view2d.h, 'Userdata');
    AVWVIEW.display_factor = display_factor;
    % replace display data
    set(view2d.h, 'Userdata', AVWVIEW);
    % display update
    vb_mri_point_select([], [], 'update');
end


%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
