function [common] = bayes_parm_editor_get_basic_gui_common(obj)
% get common value of basic gui to refer in advanced parameter gui.
% [IN]
%    obj : bayes_parm_editor object
% [OUT]
%    common.proj_root   : project root directory
%          .basis_files : basis filename {Nx1}
%          .area_key    : area_key       {Nx1}
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var') || isempty(obj) || ~ishandle(obj)
    error('invalid obj is specified.');
end

%
% --- Main Procedure
%

data = guidata(obj);
basic_gui_data = guidata(data.basic_fig);
basic_gui_handles = basic_gui_data.H;

common = struct;

% get common value from basic gui.
common.proj_root   = get(basic_gui_handles.project_root_edit, 'String');
common.basis_files = get(basic_gui_handles.basis_file_listbox, 'String');
common.area_keys   = get(basic_gui_handles.area_key_listbox, 'String');
