function [parm] = vb_parm_editor_gui(parm, parm_name)
% This function opens simple parameter editor.
% [USAGE]
%    [fig] = vb_parm_editor_gui(<parm>[, parm_name]);
% [IN]
%         parm : parameter (variable(2D), structure)
%    parm_name : parameter name(string)
%                if the name is not speicified, inputname(1) result is
%                used. This parameter exists for the case as below.
%                vb_parm_editor_gui(meg_parm{1}, 'meg_parm');
% [OUT]
%    parm: updated parameter. (= []: cancel or close button is pressed)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('parm', 'var')
    error('parm is a required parameter');
end
if ~exist('parm_name', 'var')
    parm_name = inputname(1);
end
if ~ischar(parm_name)
    error('parm_name should be character string');
end
if isempty(parm_name)
    help(mfilename);
    error('can''t get input variable name. give it by second variable ''parm_name''');
    parm = [];
    return;
end
%
% --- Main Procedure
%
fig = openfig('vb_parm_editor_gui.fig');

data = struct;
% extract GUI handles under H
data.H = guihandles(fig);

% setting for show only file parameters
data.show_file_parameters = true;
data.search_name = '';
data.case_sensitive = false;

% store parameter
data.parm_name = parm_name;
data.(parm_name) = parm;
data = vb_parm_editor_gui_data_make(data);
data.cancel_flag = true;
guidata(fig, data);

set(data.H.struct_name_text, 'String', data.parm_name);
set(data.H.contents_listbox, 'String', data.listbox_strings);
if length(data.listbox_strings) > 1
    set(data.H.contents_listbox, 'Value', 2);
else
    set(data.H.contents_listbox, 'Value', 1);
end
vb_parm_editor_gui_callback(fig, data.H.contents_listbox);

waitfor(fig, 'Visible', 'off');

% load updated data
data = guidata(fig);

if ishandle(fig)
    delete(fig);
end
% return updated data
if data.cancel_flag
    parm = [];
else
    parm = data.(data.parm_name);
end
