function [obj] = vb_batch_parm_set_remove_parm(obj, ix)
% Remove parameter from parameter set
%
% [USAGE]
%    [obj] = vb_batch_parm_set_remove_parm(<obj>, <ix>);
% [IN]
%    obj : vb_batch_parm_set object
%     ix : index of this parameter set.
% [OUT]
%    obj : vb_batch_parm_set object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix', 'var')
    error('ix is a required parameter.');
end

%
% --- Main Procedure
%
try
    obj.list(ix, :) = [];
catch
    warning('specified index is invalid.');
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive vb_batch_parm_set object.');
end
