function [obj] = vb_batch_parm_set_new(set_name)
% This is a constructor of vb_batch_parm_set class.
% This class is a container of batch parameters.
% 
% [USAGE]
%    vb_batch_parm_set_new(set_name);
% [IN]
%    set_name : container name
% [OUT]
%    obj : vb_batch_parm_set object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('set_name', 'var')
    set_name = '';
end

%
% --- Main Procedure
%
obj = struct;
obj.set_name = set_name;

obj.list = [];  % this varable will be set by batch_parm_set_add function.

%
% --- After check
%
if nargout < 1
    error('function caller should receive obj.');
end
