function [parm, parm_type] = vb_batch_parm_set_get_parm(obj, ix)
% Return the parameter and type.
%
% [USAGE]
%    [parm, parm_type] = vb_batch_parm_set_get_parm(<obj>, <ix>);
% [IN]
%    obj : vb_batch_parm_set object
%     ix : index of this parameter set.
% [OUT]
%         parm : parameter
%    parm_type : parameter type
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix', 'var')
    error('ix is a required parameter.');
end

%
% --- Main Procedure
%
parm = [];
parm_type = [];
try
    if isempty(ix), return; end
    parm      = obj.list{ix, 1};
    parm_type = obj.list{ix, 2};
catch
    warning('specified index is invalid.');
end
