function [obj, cancelled] = vb_batch_mgr_create_concrete_parm(obj)
% Create concreate parameters from Table and Tempatle parameters
%
% [USAGE]
%    [obj, cancelled] = vb_batch_mgr_create_concrete_parm(<obj>);
% [IN]
%    obj : vb_batch_mgr object
% [OUT]
%    obj : vb_batch_mgr object
%    cancelled : <<bool>>  true : creation is cancelled.
%                         false : creation is executed.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end

%
% --- Main Procedure
%
cancelled = false;

[column, data] = vb_batch_variable_table_get_data(obj.table);

% The number of Template parameters
Nparm = vb_batch_parm_set_get_num_of_parm(obj.template);


% The number of parameter set to be created.
[column, table]  = vb_batch_variable_table_get_data(obj.table);
Nvariable = length(column);
Nset = size(table, 1);

%% Are there created parameters?
%if length(obj.parm_set)
%    res = questdlg(...
%         'Parameters already exists. Overwrite?', ...
%         'Confirm', 'Yes', 'No', 'No');
%    if strcmpi(res, 'no')
%        cancelled = true;
%        return;
%    end
%end

% Are there empty cell?
flag_empty = false;
for k=1:Nset
    for j=1:Nvariable
        if isempty(table{k, j}), flag_empty = true; end
    end
end
if flag_empty
    res = questdlg(...
        'There are some empty cells in the table. Continue?', ...
        'Confirm', 'Yes', 'No', 'No');
    if strcmpi(res, 'no')
        cancelled = true;
        return;
    end
end

% Create ID strings
ix   = strmatch('$ID$', column, 'exact');
if isempty(ix)
    ids = cell(Nset, 1);
else
    ids  = table(:, ix);
end

for k=1:length(ids)
    if isempty(ids{k}), ids{k} = ['ID' num2str(k)]; end
end

obj.parm_set = cell(0);
for k=1:Nset
    % Create parameter set
    parm_set = vb_batch_parm_set_new(ids{k});

    for m=1:Nparm
        % Read Nth template parameter
        [parm, parm_type] = vb_batch_mgr_get_parm(obj, 0, m);

        % Replace Variable name to concrete value
        for n=1:Nvariable
            key   = column{n};
            value = table{k, n};
            if isempty(value), value = ''; end

            key = strrep(key, '$', '\$');     % disable meta char of '$'
            value = strrep(value, '\', '\\'); % disable escape code in value
            parm = inner_replace_key2value(parm, key, value);
        end
        % remove time stamp field
        if isfield(parm, 'time_stamp')
            parm = rmfield(parm, 'time_stamp');
        end
        parm_set = vb_batch_parm_set_add_parm(parm_set, parm, parm_type);
    end

    % Save parm_set
    obj.parm_set{k, 1} = parm_set;
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive object.');
end

function parm = inner_replace_key2value(parm, key, value)
% find key in the parameter and replace it to concrete value
% [USAGE]
% [IN]
%     parm : parameter
%      key : keyword such as '$SUBJ$', '$ID$' [STRING]
%    value : user specified value
% [OUT]
%    parm : modified parameter

fields = fieldnames(parm);
Nfields = length(fields);

for k=1:Nfields
    field = parm.(fields{k});
    if iscellstr(field) || ischar(field)
        parm.(fields{k}) = regexprep(field, key, value);
    elseif isstruct(field)
        parm.(fields{k}) = inner_replace_key2value(field, key, value);
    end
end
