function [obj, errmsg] = ...
                 vb_batch_mgr_change_variable_name(obj, old_name, new_name)
% Rename variable name
% [USAGE]
%    [obj, errmsg] = ...
%            vb_batch_mgr_change_variable_name(<obj>,<old_name>,<new_name>);
% [IN]
%         obj : vb_batch_mgr_object
%    old_name : name before changing [STRING]
%    new_name : name after changing  [STRING]
% [OUT]
%         obj : vb_batch_mgr_object
%      errmsg : error msg(when error occurs, reason is put here.)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a requierd parameter.');
end
if ~exist('old_name', 'var')
    error('old_name is a required parameter.');
end
if ~exist('new_name', 'var')
    error('new_name is a required parameter.');
end

%
% --- Main Procedure
%
[obj.table, errmsg] = ...
   vb_batch_variable_table_change_column_name(obj.table, old_name, new_name);

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
