function [parm_set] = vb_batch_mgr_get_parm_set(obj, ix)
% get parameter set.
% This is inner private function.(utility)
% [USAGE]
%    [parm_set] = vb_batch_mgr_get_focus_parm_set(<obj>, <ix>);
% [IN]
%    obj : vb_batch_mgr object
%     ix : index for focusing on parameter set. [INTEGER]
%           = 0 : template parameter set.
%           >=1 : batch parameter set.
% [OUT]
%    parm_set : vb_batch_parm_set object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix', 'var')
    error('ix is a required parameter.');
end
if ix < 0
    error('Invalid index is specified. maybe bug of the program');
end

%
% --- Main Procedure
%
try
    if ix == 0
        parm_set = obj.template;
    else
        parm_set = obj.parm_set{ix};
    end
catch
    parm_set = [];
end
