function vb_batch_list_update_concrete_parm_listbox(fig)
% update concrete parameter listbox
%
% [USAGE]
%    vb_batch_list_update_concrete_parm_listbox(<fig>);
% [IN]
%    fig : figure handle
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%
data = guidata(fig);

% get the number of parameters in the selected parameter set.
ix_main = get(data.H.concrete_parm_id_listbox, 'Value');
Nparm = vb_batch_mgr_get_num_of_parm(data.bmgr, ix_main);

% set parameter type to listbox
listbox_str = cell(0);
for k=1:Nparm
    ix_sub = k;
    [parm, parm_type] = vb_batch_mgr_get_parm(data.bmgr, ix_main, ix_sub);
    listbox_str{k, 1} = parm_type;
end

% Ajust selected line number
line_no = get(data.H.concrete_parm_listbox, 'Value');
if Nparm < 1
    line_no = 1;
elseif line_no > Nparm
    line_no = Nparm;
end
set(data.H.concrete_parm_listbox, 'String', listbox_str);
set(data.H.concrete_parm_listbox, 'Value', line_no);

% Enable/Disable components
components = [data.H.concrete_parm_upper_push;
              data.H.concrete_parm_lower_push;
              data.H.concrete_parm_remove_push;
              data.H.concrete_parm_copy_push;
              data.H.concrete_parm_edit_push];
if Nparm
    set(components, 'Enable', 'on');
else
    set(components, 'Enable', 'off');
end
