function vb_batch_list_put_log(fig, text)
% Add log to gui.
% Carriage return is added to end automatically.
% [USAGE]
%    vb_batch_list_put_log(<fig>, <text>);
% [IN]   
%     fig : figure handle of vb_batch_list gui
%    text : text to be added to log window.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if ~exist('text', 'var') || ~ischar(text)
    error('invalid text is handed.');
end

%
% --- Main Procedure
%
data = guidata(fig);

past = get(data.H.msg_edit, 'String');
if isempty(past)
    str{1} = text;
else
    str = cellstr(past);
    str{length(str)+1} = text;
end
set(data.H.msg_edit, 'String', str);
drawnow; % This command activate the change of listboxtop property.
set(data.H.msg_edit, 'listboxtop', length(str));
