function fig = vb_batch_list_new(proj_root, proj_name, proj_file, bmgr)
% make batch list gui.
% [USAGE] 
%     fig = vb_batch_list_new(<proj_root>,<proj_name>,<proj_file>, <bmgr>]);
% [IN]
%     proj_root : project root directory
%     proj_name : project name
%     proj_file : project filename
%          bmgr : vb_batch_mgr object
% [OUT]
%   fig : figure handle of gui
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('proj_root', 'var')
    error('proj_root is a required parameter.');
end
if ~exist('proj_name', 'var')
    error('proj_name is a required parameter.');
end
if ~exist('proj_file', 'var')
    error('proj_file is a required parameter.');
end
if ~exist('bmgr', 'var')
    error('bmgr is a required parameter.');
end

%
% --- Main Procedure
%
fig = openfig('vb_batch_list.fig');

H = guihandles(fig);
H.figure = fig;

data = struct;
data.H = H;

% this gui edits this builder
data.bmgr = bmgr;
data.initial_state = bmgr;

data.proj_root = proj_root;
data.proj_name = proj_name;
data.proj_file = proj_file;

set(H.builder_name_edit, 'String', vb_batch_mgr_get_name(bmgr));
set(H.proj_name_edit, 'String', proj_name);
set(H.proj_root_edit, 'String', proj_root);

% save data
guidata(fig, data);

% update screen
vb_batch_list_update_screen(fig);
