function vb_batch_list_callback(fig, hObj)
% callback function for batch list gui.
% [USAGE]
%    vb_batch_list_calback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of batch list gui.
%    hObj : event component handle.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if ~exist('fig', 'var') || isempty(hObj)
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%

% load data (@see vb_batch_list_new.m)
data = guidata(fig);
H = data.H; % component handles


switch(hObj)
    case H.builder_name_edit
        name = get(H.builder_name_edit, 'String');
        data.bmgr = vb_batch_mgr_set_name(data.bmgr, name);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Template parameter editor
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    case H.insert_mkdir_push
        [data.bmgr] = vb_batch_mgr_add_tool_mkdir(data.bmgr);
    case H.upper_push
        idx1 = get(H.template_parameter_listbox, 'Value');
        idx2 = idx1-1;
        if idx2 == 0
            return;
        else
            [data.bmgr] = vb_batch_mgr_swap_parm(data.bmgr, 0, idx1, idx2);
            set(H.template_parameter_listbox, 'Value', idx2);
        end
    case H.lower_push
        [last] = vb_batch_mgr_get_num_of_parm(data.bmgr, 0);
        idx1 = get(H.template_parameter_listbox, 'Value');
        idx2 = idx1+1;
        if idx1 == last
            return;
        else
            [data.bmgr] = vb_batch_mgr_swap_parm(data.bmgr, 0, idx1, idx2);
            set(H.template_parameter_listbox, 'Value', idx2);
        end
    case H.remove_push
        res = questdlg('Selected parameter will be removed. continue?',...
                 'Confirm', 'Yes', 'No', 'Yes');
        if strcmpi(res, 'yes')
            n = get(H.template_parameter_listbox, 'Value');
            [data.bmgr] = vb_batch_mgr_remove_parm(data.bmgr, 0, n);
        end
    case H.copy_push
        n = get(H.template_parameter_listbox, 'Value');
        [data.bmgr] = vb_batch_mgr_duplicate_parm(data.bmgr, 0, n);
    case {H.edit_push, H.template_parameter_listbox}
        if hObj == H.template_parameter_listbox
            if strcmpi(get(fig, 'SelectionType'), 'open')
                % If listbox is double clicked, edit parameter
            else
               % single click
                return;
            end
        end
        n = get(H.template_parameter_listbox, 'Value');
        [data.bmgr, errmsg] = vb_batch_mgr_edit_parm(data.bmgr, 0, n);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Variable and Table definition
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    case H.variable_add_push
        add_name = '';
        while(1)
            % input variable name
            add_name = inputdlg('Input variable name', 'Add variable', ...
                                     1, {add_name});
            if isempty(add_name), return; end
            % make '$VALUE$'
            add_name = strrep(add_name{1}, '$', '');
            add_name = ['$' add_name '$'];
            % add variable to the table
            [data.bmgr, errmsg] = vb_batch_mgr_add_variable(data.bmgr, add_name);
            if ~isempty(errmsg)
                h = errordlg(errmsg, 'Error');
                waitfor(h);
            else
                break;
            end
        end
    case {H.variable_rename_push, H.variable_listbox}
        if hObj == H.variable_listbox
            if strcmpi(get(fig, 'SelectionType'), 'open')
                % If listbox is double clicked, rename variable
            else
               % single click
                return;
            end
        end

        selected = get(H.variable_listbox, 'Value');
        strs     = get(H.variable_listbox, 'String');
        old_name = strs{selected};
        new_name = old_name;
        while(1)
            % INPUT new name
            new_name = ...
                inputdlg('Input variable name', 'Rename variable', ...
                         1, {new_name});
            if isempty(new_name), return; end
            % make '$VALUE$'
            new_name = strrep(new_name{1}, '$', '');
            new_name = ['$' new_name '$'];
            % Register
            [data.bmgr, errmsg] = ...
              vb_batch_mgr_change_variable_name(data.bmgr, old_name, new_name);
            if ~isempty(errmsg)
                h = errordlg(errmsg, 'Error');
                waitfor(h);
            else
                break;
            end
        end
    case H.variable_remove_push
        % selected variable name
        listbox_contents = get(H.variable_listbox, 'String');
        selected = get(H.variable_listbox, 'Value');
        if ischar(listbox_contents)
            listbox_contents = {listbox_contents};
        end
        remove_name = listbox_contents{selected};
        head = sprintf('Variable(%s)', remove_name);
        res = questdlg([head ' and its table data will be removed. continue?'],...
                 'Confirm', 'Yes', 'No', 'Yes');
        if strcmpi(res, 'yes')
            % remove variable from the table
            [data.bmgr] = vb_batch_mgr_remove_variable(data.bmgr, remove_name);
        end
    case H.edit_table_push
        components = [H.variable_add_push;
                      H.variable_remove_push;
                      H.variable_rename_push;
                      H.create_concrete_parm_push];
        set(components, 'Enable', 'off');
        [data.bmgr] = vb_batch_mgr_edit_table(data.bmgr);
        set(components, 'Enable', 'on');
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Make Parameter button
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    case H.create_concrete_parm_push
        % Clean up output ids
        [data.bmgr] = vb_batch_mgr_set_output_index_list(data.bmgr, []);
        % Create concrete parameters from Table and Template
        [data.bmgr, cancelled] = vb_batch_mgr_create_concrete_parm(data.bmgr);
        if cancelled
            vb_batch_list_put_log(fig, 'Cancelled operation(Create parameter set).');
        else
            vb_batch_list_put_log(fig, ['Parameter set were created.(' datestr(now,31) ')']);
        end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Created parameter set
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    case H.concrete_parm_upper_push
        ix_main = get(H.concrete_parm_id_listbox, 'Value');
        idx1 = get(H.concrete_parm_listbox, 'Value');
        idx2 = idx1-1;
        if idx2 == 0
            return;
        else
            [data.bmgr] = vb_batch_mgr_swap_parm(data.bmgr, ix_main, idx1, idx2);
            set(H.concrete_parm_listbox, 'Value', idx2);
        end
    case H.concrete_parm_lower_push
        ix_main = get(H.concrete_parm_id_listbox, 'Value');
        [last] = vb_batch_mgr_get_num_of_parm(data.bmgr, ix_main);
        idx1 = get(H.concrete_parm_listbox, 'Value');
        idx2 = idx1+1;
        if idx1 == last
            return;
        else
            [data.bmgr] = vb_batch_mgr_swap_parm(data.bmgr, ix_main, idx1, idx2);
            set(H.concrete_parm_listbox, 'Value', idx2);
        end
    case H.concrete_parm_remove_push
        ix_main = get(H.concrete_parm_id_listbox, 'Value');
        ix_sub  = get(H.concrete_parm_listbox, 'Value');
        res = questdlg('Selected parameter will be removed. continue?',...
                 'Confirm', 'Yes', 'No', 'Yes');
        if strcmpi(res, 'yes')
            [data.bmgr] = vb_batch_mgr_remove_parm(data.bmgr, ix_main, ix_sub);
        end
    case H.concrete_parm_copy_push
        ix_main = get(H.concrete_parm_id_listbox, 'Value');
        ix_sub  = get(H.concrete_parm_listbox, 'Value');
        [data.bmgr] = vb_batch_mgr_duplicate_parm(data.bmgr, ix_main, ix_sub);
    case {H.concrete_parm_edit_push, H.concrete_parm_listbox}
        if hObj == H.concrete_parm_listbox
            if strcmpi(get(fig, 'SelectionType'), 'open')
                % If listbox is double clicked, edit parameter
            else
               % single click
                return;
            end
        end
        ix_main = get(H.concrete_parm_id_listbox, 'Value');
        ix_sub  = get(H.concrete_parm_listbox, 'Value');
        if ~isempty(ix_main) && ~isempty(ix_sub)
            [data.bmgr, errmsg] = ...
                vb_batch_mgr_edit_parm(data.bmgr, ix_main, ix_sub);
        end
    %%%%%%%%%%%%%%%%%%%%
    % Build batch file
    %%%%%%%%%%%%%%%%%%%%
    case H.choose_id_list_push
        Nparm_set = vb_batch_mgr_get_num_of_parm_set(data.bmgr);
        id_strings = cell(Nparm_set, 1);
        for k=1:Nparm_set
            ix_main = k; ix_sub = 1;
            [p, p_type, id_strings{k,1}] = ...
                    vb_batch_mgr_get_parm(data.bmgr, ix_main, ix_sub);
        end
        [id_list, IsOK] = listdlg('PromptString', 'Choose IDs for output', ...
                              'ListString', id_strings, ...
                              'InitialValue', [1:length(id_strings)], ...
                              'ListSize', [160, 300]);
        if IsOK
            [data.bmgr] = vb_batch_mgr_set_output_index_list(...
                                                      data.bmgr, id_list');
        end
    case H.build_batch_push
        define = vb_define_extension;
        [dir, fnames] = vb_file_select({define.VBMEG_BATCH_EXTENSION},...
                                       'Save VBMEG batch file', true);
        if ~isempty(dir)
            output_file = fullfile(dir, fnames{1});
            if exist(output_file, 'file') == 2
                res = questdlg('File already exists. Overwrite?', ...
                            'Confirm', 'Yes', 'No', 'Yes');
                if strcmpi(res, 'no'), return; end
            end
            proj_info = struct;
            proj_info.proj_name = data.proj_name;
            proj_info.proj_root = data.proj_root;
            proj_info.proj_file = data.proj_file;
            [result, msg] = ...
                vb_batch_mgr_build_batch_file(data.bmgr, ...
                                              proj_info, output_file);
            if result == FAILURE
                errordlg('Failed to save file.');
                vb_batch_list_put_log(fig, msg);
            else
                vb_batch_list_put_log(fig, ...
                          ['batchfile : ' output_file ' was created!']);
                vb_batch_list_put_log(fig, ...
                          ['run script : vb_run_batch(batchfile, logfile);']);
            end
        end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Other buttons(save, cancel, help..)
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    case H.save_push
        save = true;
        inner_close_batch_list(fig, data.bmgr, save);
        return;
    case {H.cancel_push, H.figure}
        if isequal(data.initial_state, data.bmgr) == false
            res = questdlg('Save current settings?',...
                          'Confirm', 'Yes', 'No', 'Cancel', 'Yes');
            if strcmpi(res, 'yes')
                save = true;
                inner_close_batch_list(fig, data.bmgr, save);
            elseif strcmpi(res, 'no');
                save = false;
                inner_close_batch_list(fig, data.bmgr, save);
            end
        else
            save = false;
            inner_close_batch_list(fig, data.bmgr, save);
        end
        return;
    case H.help_push
        h = vb_batch_list_help;
end

% save data
guidata(fig, data);
vb_batch_list_update_screen(fig);


function inner_close_batch_list(fig, bmgr, save)

% save current settings to project file.
if save
    [result, errmsg] = project_mgr_builder_close(bmgr);
    while(1)
        if result == SUCCESS
            closereq;
            return;
        else
            vb_batch_list_put_log(fig, errmsg);
            res = questdlg('Failed to save file. Do you retry?', ...
                     'Confirm', ...
                     'Yes', 'No', 'Yes');
            if strcmpi(res, 'yes')
                [result, errmsg] = project_mgr_builder_close(bmgr);
            elseif strcmpi(res, 'no')
                return;
            end
        end
    end
else
    project_mgr_builder_close([]);
    closereq;
end
