function	[V2ix ,P4 ] = vb_spm_to_cortex_org(spmx3,spmz,V)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

error('This function is a canditate to be removed, but invoked.');

zmin  = min(spmx3(:,3)); 
zmax  = max(spmx3(:,3)); 
zstep = 1;  % searching range of SAG slices
vstep = sqrt(3);  % distance that dipoles are selected

V2ix  = [];  % index of active dipoles

%all_calc = fix((zmax-zmin)/zstep)+1;  % for indicator values

for zi=zmin:zstep:zmax

    % select SPM sources on this slice
    pix1 = find(spmx3(:,3)>=zi & spmx3(:,3)<zi+zstep);  

    % select dipoles on this slices
    pix2 = find(V(:,3)>=zi & V(:,3)<zi+zstep);  

    % not find
    if min(size(pix1))<1 | min(size(pix2))<1, continue; end  

	% find dipoles inside SPM area
    pix3=find(V(pix2,1)>=min(spmx3(pix1,1)) & ...
    		  V(pix2,1)<=max(spmx3(pix1,1)) & ...
			  V(pix2,2)>=min(spmx3(pix1,2)) & ...
			  V(pix2,2)<=max(spmx3(pix1,2)));  

    % find SPM near each dipole
    k=0;  % number of SPM-voxels 

    for j=1:size(pix3,1),

        d  = spmx3(pix1,:)-repmat(V(pix2(pix3(j)),:),size(pix1),1);

        dd = d(:,1).^2+d(:,2).^2+d(:,3).^2;

        % the least distance between dipole and SPM-voxel
        dy = min(dd);  

        % index of SPM-voxels near one dipole
        if dy<vstep^2, 
        	k	   = k+1; 
        	dix(k) = pix2(pix3(j)); 
        end  
    end

    % add index of active dipoles
    if k~=0, V2ix=unique([V2ix,dix]); end  

    clear dix;
end

clear zmin zmax zstep pix1 pix2 pix3 d dd dy;

%
% --- set the active strength of the dipoles
%
fprintf('\n -> calculate activity of dipoles......');

dok0 = 1;  %size of fMRI voxel
dok1 = 3;  % weight to average spmz
dok2 = 6; % distance whos SPM voxels are selected
j	 = 0; 

% value of Gauss function
for i=dok0/2:dok0:dok2+dok0/2, 
	j	   = j+1; 
	gaf(j) = exp(-i^2/dok1^2); 
end  

ndip0 = size(V2ix,2);  % number of active dipoles
P3	  = [];

for i=1:ndip0,

    % distance between selected dipoles and SPM
    d		  = spmx3 - repmat(V(V2ix(i),:),size(spmx3,1),1);

    dd		  = sqrt(d(:,1).^2+d(:,2).^2+d(:,3).^2); 
    
    [ddy,ddi] = sort(dd);
    
    % averaged SPM strength of each dipoles 
    P3(i)	  = 0; 
    wwsum	  = 0;
    
    for l=1:size(ddy,1),
        if ddy(l)>dok2, break; end
        if 0, ww=exp(-ddy(l)^2/dok1^2);
        else, ww=gaf(fix(ddy(l)/dok0)+1); 
        end;
        
        P3(i)=P3(i)+spmz(ddi(l))*ww;
    end
    
    if i==1 | wwsum>wmax, wmax=wwsum; end
end;

% enhancement
P4=P3./max(P3); 
