function [Vindx, J ,emin] = vb_dipole_estimate(bexp, basis, L)
% ---
% function [ Vindx, J ,emin ] = vb_dipole_estimate(bexp, basis, L)
% ñݡ
%
% Vindx : ꤵ줿ݡΥǥå
%       : ݡΰֺɸ = V(Vindx,:) 
% J     : ݡή
% emin  : 
%
% bexp  : MEG-data (Nsensor ,Time) 
% basis : Lead Field (Ndipole, Nsensor) 
% L = 2 (ή)
% ---
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<3,
  L = 2;
end;

basis = basis';		% basis(Nsensor, Ndipole)

[N , M] = size(basis);
Npoint	= M/L;

err 	= zeros(Npoint,1);
JJ	= zeros(Npoint,size(bexp,2));

id	= 0:(L-1);
id	= Npoint*id; % [ 0 , Npoint] for L=2

Bnorm   = sum(sum(bexp.^2));

for n = 1:Npoint,
  % Lead Field for the n-th dipole
  G  = basis(: , n + id);
	
  % Min. ( bexp - G*J )^2
  GG = inv( G'*G ); % (L x L) matrix inverse
	
  % Diploe current
  J  = GG * (G' * bexp);	% (L x T)
	
  % Reconstruction error
  err(n)  = sum(sum( (bexp - G * J).^2 ))/Bnorm;
  JJ(n,:) = sqrt(sum( J.^2, 1));
end;

[ emin, Vindx ] = min( err );
J = JJ(Vindx,:);
