function	err = vb_dipole_error(V, BB, pick, Qpick, Wsensor)
% Error for dipole estimation (Biot-Savart)
%  err = vb_dipole_error(V, BB, pick, Qpick, Wsensor)
% --- Output
% err  : Reconstruction error
%
% --- INPUT
%  V      : dipole position (Ndipole x 3)
%  V(n,:) : dipole position (3-D coordinate) at n-th vertex
%
% MEG covariance matrix
% BB    = bexp*bexp';	% BB(Nsensor,Nsensor)
% bexp   : MEG-data   (Nsensor ,Time) 
%
%  pick(k, 1:3) : Sensor coil position  : , 
% Qpick(k, 1:3)	: Sensor coil direction : 
%
% Wsensor(m,n) = n-th coil weight for m-th sensor channel
%    basis(channel,dipole) = Wsensor * basis(coil,dipole)
%
% ж˻Ҽ׻
% x0 ж˻ J0  ¬ X ˺뼧 Q ͱ
% B0 = Q*(JJ x Xd)/|Xd|^3 , Xd = X - x0
%
% 2006-12-16 made by M.Sato
% 2007-4-3 made by M.Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


NV	  = length(V(:))/3;		% Number of dipoles
V     = reshape(V,[NV 3]);

% 3 current directions
vec1 = zeros(NV,3); vec1(:,1) = 1;
vec2 = zeros(NV,3); vec2(:,2) = 1;
vec3 = zeros(NV,3); vec3(:,3) = 1;

% magnetic field by Biot-Savart
G1 = vb_dipole_magnetic(V, vec1, pick, Qpick ); 
G2 = vb_dipole_magnetic(V, vec2, pick, Qpick ); 
G3 = vb_dipole_magnetic(V, vec3, pick, Qpick ); 

% G : Lead Field (NV*L, Nsensor)
G  = [G1; G2; G3]* Wsensor';

Bnorm = sum(diag(BB));

GGinv = pinv( G*G' ); % (NV*L x NV*L) matrix inverse

% Reconstruction error
% Error = ( B - G'*J )^2 = B^2  - ( B'* G'* GGinv * G * B )
err  = 1 - sum(sum(G.*(GGinv*G*BB)))/Bnorm;

