function [B, Model, nGact, nGall, nGGall, Cov, Wact, Wbck, ...
             bsnorm, ix_act, ix_bck, vb_parm] ...
         = vb_load_result(proj_root, resultfile, ix_area)
% Load VB estimation result and necessary data for current reconstruction
%   [B, Model, nGact, nGall, nGGall, Cov, Wact, Wbck, ...
%       bsnorm, ix_act, ix_bck, vb_parm] ...
%   = vb_load_result(proj_root, resultfile, ix_area)
% --- Input
% proj_root
% resultfile : result file obtained by VB estimation
% ix_area : Position index to calculate estimated current
%    If 'ix_area' is empty or not given, 
%    currents in the focal region are calculated
%
% 2006-08-31 M. Sato
% 2006-11-11 M. Sato
% If 'ix_area' is empty, original focal area is used
% instead of extended focal area by spatial smoothing
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


if ~isempty(proj_root)
  resultfile = fullfile(proj_root, resultfile);
end  

load(resultfile, 'bayes_parm','Model','Cov','vb_parm');

if ~isempty(proj_root)
  bayes_parm_abs = vb_parm_absolute_path(proj_root, bayes_parm);
else
  bayes_parm_abs = bayes_parm;
end

if isfield(bayes_parm_abs,'remove_crossed_area'),
	remove_crossed_area = bayes_parm_abs.remove_crossed_area;
else
	remove_crossed_area = OFF;
end

% MEG data preparation
[B] = vb_megdata_preparation(bayes_parm_abs);

% Preparation of lead fields
[nGall, bsnorm, ix_global, ix_global_ex, Wall, Lbck] = ...
	vb_global_leadfield_preparation(bayes_parm_abs);
[nGact, ix_focal, ix_focal_ex, Wact, Lact]  =  ...
	vb_focal_leadfield_preparation(bayes_parm_abs, bsnorm);

if remove_crossed_area == ON,
	% Remove focal area from global area
	switch bayes_parm_abs.forward_model
	case 'focal+global',
		[nGall, bstmp, ix_global, ix_global_ex, Wall, Lbck] = ...
			vb_global_leadfield_preparation(bayes_parm_abs, bsnorm, ON );
	case 'focal',
		ix_global_ex = [];
	end
end

%%%% Find active current area

% Current variance
A_inv = sum(Model.a , 2);	% sum over all time window
Nvact = vb_parm.Nvact;	    % # of active vertex 

% Multiply smoothing filter
if bayes_parm_abs.variance_orientation == ON
	A_inv = reshape(A_inv, [Nvact Lact]);
	W = sum( Wact * A_inv ,2);
else
	W = Wact*A_inv;
end

% Find nonzero component of (Wact * A_inv) : active current region
ix_act_nz   = find( W > 0 );
ix_focal_nz = ix_focal_ex(ix_act_nz);

% Area in which current is calculated
if isempty(ix_area),
	ix_area = ix_focal;		% original focal area
%	ix_area = ix_focal_nz;	% extended focal area by spatial smoothing
end

% Select vertex index 'ix_area' within the active current region
[j_tmp, ix_area_nz] = vb_index2indexsub(ix_area, ix_focal_nz);

%%%% Area information where the currents are reconstructed.

% Convert vertex index to index within the active current
% Indices outside 'ix_focal_ex' are removed from current indices 'ix_area'

% ix_act : current indices w.r.t all vertices
% j_act  : current indices 'ix_act' w.r.t ix_focal_ex
[j_act, ix_act] = vb_index2indexsub(ix_area_nz, ix_focal_ex);

% Global(background) area is independent of active current region
if remove_crossed_area == OFF
	% select active region
	[k_bck, ix_bck] = vb_index2indexsub(ix_area_nz, ix_global_ex);
else
	[k_bck, ix_bck] = vb_index2indexsub(ix_area, ix_global_ex);
end

% # of focal window
Lact     = vb_parm.Norient;
Lact_var = vb_parm.Norient_var;
Njact	 = vb_parm.Njact;	        % # of active current parameters
Nvact_area = length(ix_act);	    % # of active vertex in area
Njact_area = Nvact_area * Lact;     % # of current parameters in area

% # of global window 
Lbck  = vb_parm.Norient_all;
Nvall = length(ix_global);         % # of dipoles in the background 
Nvall_area = length(ix_bck);       % # of background points in area
Njall_area = Nvall_area* Lbck ;    % # of current parameters in area

vb_parm.Njact_area = Njact_area;
vb_parm.Njall_area = Njall_area;

fprintf('# of active current vertex = %d\n', Nvact_area)
fprintf('# of background vertex = %d\n', Nvall_area)

Nsession = vb_parm.Nsession;	% Number of sessions

%%  Gb * Gb'
for n = 1 : Nsession
 	nGGall{n} = nGall{n}*nGall{n}';    
end

%% Restrict smoothing filter 'W' to estimation points
Wact = Wact(j_act,:);	% Nvact_area x Nvact
Wbck = Wall(k_bck,:);   % Nvall_area x Nvall

%% Gb*Wb' restricted to ix_area 
%% --- For faster computation ---
for n=1:Nsession
	Gb   = nGall{n};   % Lead field of background
	Nch  = size(Gb,1); % # of sensor
	
	GbW  = reshape(Gb,  [Nch*Lbck Nvall]) * Wbck'; % [Nch*Lbck x Nvall_area]
	GbW  = reshape(GbW, [Nch Lbck*Nvall_area]);    % [Nch x Lbck*Nvall_area]
	
	nGall{n} = GbW;
end

%	switch Lbck
%	case 1, 
%		GbW  =  Gb*Wbck';
%	case 2, 
%		GbW  = [Gb(:,1:Nvall)*Wbck', Gb(:,Nvall+1:2*Nvall)*Wbck'];
%	case 3,
%		GbW  = [Gb(:,1:Nvall)*Wbck', Gb(:,Nvall+1:2*Nvall)*Wbck', ...
%		        Gb(:,2*Nvall+1:3*Nvall)*Wbck'];
%	end

clear Gb;
