function [KW, KW0, Var, R] = ...
   vb_invfilter_calc_z(a_inv, v_inv, G, Gb, GG, Cov)
% Inverse filter for (Z-)current reconstruction
%   [KW, KW0, Var, R] = ...
%      vb_invfilter_calc(a_inv, v_inv, G, Gb, GG, Cov)
%
% --- Input
% a_inv : A    :  variance of active current                    
% v_inv : tau  : variance of active current                   
% G     : Ga : leadfield of active current (smoothed) G0*Wa  
% Gb    : leadfield of background current (smoothed) G0*Wb
% GG    =  Gb*Gb'
% Cov   : Sensor noise covariance matrix
% ---Output
% KW   : Inverse filter for active current
% KW0  : Inverse filter for background current
% Var  : posterior variance
%   When active area is empty,
%   posterior variance for background area is calculated
% R    : Estimation gainn = diag(Resolution matrix)
% --- Current reconstruction
% Zact = (KW  * Bt);
% Zbck = (KW0 * Bt);
% Original vertex current can be obtained by applying spatial smoothing filter
% Jact = Wact * Zact
% Jbck = Wbck * Zbck
%
% 2007-3-5 M.Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Nact   # of estimated variance in focal area
% Njact  # of current in focal area
% Njbck  # of current in global area

error('This function is a canditate to be removed, but invoked.');

[Nch, Njact] = size(G);
Njbck = size(Gb,2);
Nact  = length(a_inv);
Ratio = Njact/Nact;  % # of active current = Njact = Ratio * (# of a_inv)

A_inv  = repmat(a_inv , [Ratio Nch]); % [Njact x Nch]
AGt    = A_inv .* G';          % A*Ga'
GGA    = G * AGt + v_inv * GG; % Ga*A*Ga' + tau*Gb*Gb'
SB_inv = inv( GGA + Cov );     % SB^(-1) = [Ga*A*Ga' + tau*Gb*Gb'+Cov]^{-1} 	
%%%% Inverse filter
KW  = AGt * SB_inv;            % A*Ga'*(SB)^{-1}   : active
KW0 = v_inv .* (Gb' * SB_inv); % tau*Gb'*(SB)^{-1} : back 

if nargout < 3, return; end;

%%%% Posterior variance calculation

% Posterior variance
if Njact > 0
	if Njbck == Njact
	    % PP = (A*Ga') + v_inv*(Gb')
	    PP = (AGt + v_inv .* Gb' );
	    % A + tau - (A*Ga'+tau*Gb')*SB_inv*(...)'
	    Var = repmat(a_inv , [Ratio 1]) + v_inv - sum((PP*SB_inv).*PP ,2) ;
	    R   = sum((KW + KW0) .* G' ,2);
	else
	    % A - (A*Ga')*SB_inv*(...)'
	    Var = repmat(a_inv , [Ratio 1]) - sum((AGt*SB_inv).*AGt ,2) ;
	    R   = sum(KW .* G' ,2);
	end
elseif Njbck > 0
    % tau - (tau*Gb')*SB_inv*(...)'
    Var = v_inv - v_inv^2 * sum(Gb.*(SB_inv*Gb) ,1)';
    R   = sum(KW0 .* Gb' ,2);
end

