function	Zpw = vb_feature_calc(B, VBfreq)
% Calculate bandpass power of estimated current
% --- Usage
%   T = size(Bt,2);
%   VBfreq = prepare_online_vb_filter(VBfilt,Fs,T,freq_range)
%
%   Zpw = vb_feature_calc(Bt, VBfreq);
% --- Input
% Bt = MEG/EEG data (Nch,Tsample)
% KW = VB inverse filter  (Njact,Nch)
%
% freq_range : band frequency for feature extraction [Nband x 2]
% freq_range(n ,:)  = [freq_low freq_high] Hz (for n-th band)
% Fs     : sampling frequency [Hz]
% Wfreq  : Sparse matrix to get sum of frequency component in each band
% fxlist : index list for bandpass components in FFT-signal
% NFFT   : number of time points to calculate FFT
% --- Output
% Zf(:,n) : n-th band power summed over [freq_range(n,1) freq_range(n,2)]
% Bt(:,t) : signal at time index t (t=1:Nt)
% Bf = fft( vb_repmultiply(Bt, hanning(Nt)') ,NFFT, 2);
% Zf = Bf(:,fxlist) ).^2 * Wfreq 
% Zf = current of Njact vertices (Njact,)
%
% Masa-aki Sato 2008-12-2
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Current

Twindow = VBfreq.Twindow;
Nwindow = size(Twindow,1);
Nact    = size(VBfreq.KW,1);
Nband   = size(VBfreq.Wfreq,2);

Zpw = zeros(Nact,Nband,Nwindow);

if isfield(VBfreq,'fft_window') 
	fft_window = VBfreq.fft_window;
else
	fft_window = 0;
end

for n=1:Nwindow
	% FFT of MEG/EEG data with Hanning window
	Bt = B(:,Twindow(n,1):Twindow(n,2));
	
	Nt = size(Bt,2);
	
	if fft_window==1,
		Bt = vb_repmultiply(Bt, hanning(Nt)');
	end
	
	% FFT
	Bf  = fft( Bt , VBfreq.NFFT, 2);
	
	% select frequency components
	Bfx = Bf(:, VBfreq.fxlist);
	
	% Current reconstruction in frequency space
	Zf = abs( VBfreq.KW * Bfx ).^2 ;
	
	% sum over frequency bands
	Zpw(:,:,n) = Zf * VBfreq.Wfreq;
end


