function [ix_peak,J_peak] ...
    = vb_extract_peak_timecourse(J,ix,num_iter,t0,t_size,t_range,ix_area)
%------------------------------------------------------------
% function [ix_peak,J_peak] ...
%     = vb_extract_peak_timecourse(J,ix,num_iter,t0,t_size,t_range,ix_area)
%
% *** Input parameters
% - J       :
% - ix      :
% - num_iter:
% - t0      :
% - t_size  :
% - t_range :
% - ix_area :
%
% *** Output parameters
% - ix_peak :
% - J_peak  : 
%
% 2005-03-17 Taku Yoshioka
%------------------------------------------------------------
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Search area
ixx = [];
for i=1:length(ix_area)
  ix_tmp = find(ix==ix_area(i)); 
  if ~isempty(ix_tmp), ixx = [ixx; ix_tmp]; end; 
end
ix_area_back = zeros(size(J,1),1);
ix_area_back(ix_area) = 1:length(ix_area); 

% Spatial mask
Jmask0 = zeros(size(J,1),1); 
Jmask0(ixx) = 1; 

% Temporal mask
Jmask1 = zeros(1,size(J,2)); 
Jmask1(t_range) = 1; 

% Loop
t_max = t0; 
for i=1:num_iter
  fprintf('Iteration %d\n',i);
  
  % Time window
  Twin = max(1,(t_max-t_size)):min(size(J,2),(t_max+t_size));
  fprintf('Time window: [%d,%d]\n',min(Twin),max(Twin)); 
   
  % Find spacial peak
  Jspace = sum(abs(J(:,Twin)),2);
  Jspace = Jspace.*Jmask0; 
  [tmp,ix_max] = max(Jspace);
  fprintf('Spacial paek: %d\n',ix_area(ix_area_back(ix_max))); 
  
  % Find temporal peak
  Jtime = abs(J(ix_max,:)).*Jmask1; 
  [tmp,t_max] = max(Jtime);
  fprintf('Temporal peak: %d\n',t_max);
end

ix_peak = ix_area(ix_area_back(ix_max)); 
J_peak = J(ix_peak,:); 

