function [ix_act, jx_act, Lact] = ...
          vb_current_area_info_z(Jinfo,ix_area)
% find selected area index in current file
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Lact =Jinfo.Lact ;
ix_act =Jinfo.ix_act ;
Nact = length(ix_act);

if ~isempty(ix_area),
	% Select vertex index 'ix_area' within the active current region
	[jx_act, ix_act] = vb_index2indexsub(ix_area, ix_act);
else
	jx_act = 1:length(ix_act);
end

if Lact > 1
	jx_act = repmat(jx_act(:),1,Lact) ...
		   + repmat([0:Lact-1]*Nact,length(jx_act),1);
	jx_act = jx_act(:);
end
