function	Jact = vb_convert_current_j(Zact, Wact, Lact)
% Jact = vb_convert_current_j(Zact, Wact, Lact)
% Jact = Wact * Zact
% Wact : Spatial smoothing matrix of focal window
% Lact : # of current component
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[Njact, Tall, Ntry] = size(Zact);

if Njact==0, Jact = Zact; return; end;

[Njact_ex , NWact]= size(Wact);

if NWact*Lact ~= Njact,
	fprintf('size(W)= [%d x %d], size(Zact)= %d, L = %d\n', ...
			Njact_ex, NWact, Njact, Lact)
	error('Size of W is not matched to J')
end

Jact  = Wact * reshape(Zact,  [Njact/Lact, Lact*Tall*Ntry]); 
Jact  = reshape(full(Jact),  [Njact_ex*Lact, Tall, Ntry]); 

return
