
#include "matrix.h"
#include <math.h> /* Needed for the ceil() prototype */
#include "mex.h"


void mexFunction(
		 int nlhs,       mxArray *plhs[],
		 int nrhs, const mxArray *prhs[]
		 )
{
    /* Declare variable */
    mwSize   m,n,nz,nz1,nzs;
    mwIndex  ki,kj0,k,ipk,jpk,*irs,*jcs;
    double   *ip,*jp,*z;

	/*  Check for proper number of arguments. */
	if(nrhs!=3) 
	  mexErrMsgTxt("5 inputs required.");
	if(nlhs!=1) 
	  mexErrMsgTxt("One output required.");
	  
	/* Indx = sp_calc_index(I,J,S) */
	
	/*  Get the number of elements. */
	nz  = (mwSize) mxGetNumberOfElements(prhs[0]);
	nz1 = (mwSize) mxGetNumberOfElements(prhs[1]);

	/*  Check for consistency of arguments. */
	if(nz!=nz1) 
	  mexErrMsgTxt("I,J,V should be the same length");

	/*  Get pointer of input */
	ip = mxGetPr(prhs[0]);
	jp = mxGetPr(prhs[1]);

	if (!mxIsSparse(prhs[2])) {
	  mexErrMsgTxt("3rd input must be sparse matrix");
	}
	
    irs = mxGetIr(prhs[2]);
    jcs = mxGetJc(prhs[2]);
	nzs = (mwSize) mxGetNzmax(prhs[2]);
	
	/*  Get the number of dim. */
	m = mxGetM(prhs[2]);
	n = mxGetN(prhs[2]);

    /* Allocate space for matrix */
	plhs[0] = mxCreateDoubleMatrix(nz,1,mxREAL);
	
	/*  Create a C pointer to a copy of the output matrix. */
	z = mxGetPr(plhs[0]);

    /* set nonzero elements */

    for (k=0; (k < nz ); k++) {
    	
		ipk = (mwIndex) (ip[k] - 1);
		jpk = (mwIndex) (jp[k] - 1);
		
		kj0 = jcs[jpk];
		
		for (ki=kj0; (ki < nzs); ki++){
			if (irs[ki] == ipk)	break;
		}
		
		z[k] = (double) (ki);
    }
}
