
#include "matrix.h"
#include <math.h> /* Needed for the ceil() prototype */
#include "mex.h"


void mexFunction(
		 int nlhs,       mxArray *plhs[],
		 int nrhs, const mxArray *prhs[]
		 )
{
    /* Declare variable */
    mwSize   nz,nz1,nzs;
    mwIndex  k,ipk;
    double   *ip,*vp,*zp;

	/*  Check for proper number of arguments. */
	if(nrhs!=3) 
	  mexErrMsgTxt("5 inputs required.");
	if(nlhs!=0) 
	  mexErrMsgTxt("No output required.");
	  
	/* sp_add_value(I,V,S) */
	
	/*  Get the number of elements. */
	nz  = (mwSize) mxGetNumberOfElements(prhs[0]);
	nz1 = (mwSize) mxGetNumberOfElements(prhs[1]);

	/*  Check for consistency of arguments. */
	if(nz!=nz1) 
	  mexErrMsgTxt("I,V should be the same length");

	/*  Get pointer of input */
	ip = mxGetPr(prhs[0]);/* sparse matrix index */
	vp = mxGetPr(prhs[1]);/* add value */

	if (!mxIsSparse(prhs[2])) {
	  mexErrMsgTxt("3rd input must be sparse matrix");
	}

	zp = mxGetPr(prhs[2]);/* nonzero value */

	nzs = (mwSize) mxGetNzmax(prhs[2]);
	
	if (nzs < nz) {
	  mexErrMsgTxt("Index is too large");
	}
    /* add elements */

    for (k=0; (k < nz ); k++) {
		ipk = (mwIndex) (ip[k]);
		if (nzs <= ipk) {
		  mexErrMsgTxt("Index is over");
		}
		zp[ipk] = zp[ipk] + vp[k];
    }
}

	/*  	
    ir = mxGetIr(prhs[2]);
    jc = mxGetJc(prhs[2]);
    */

	/*  Get the number of dim. 
	m = (mwSize) mxGetM(prhs[2]);
	n = (mwSize) mxGetN(prhs[2]);
	*/
    /* Allocate space for sparse matrix */
    /* 
    plhs[0] = mxCreateSparse(m,n,nzs,mxREAL);

    irs = mxGetIr(plhs[0]);
    jcs = mxGetJc(plhs[0]);
	z   = mxGetPr(plhs[0]);

    for (k=0; (k <= n ); k++) {
    	jcs[k] = (mwIndex) jc[k] ;
    }
    for (k=0; (k < nzs ); k++) {
	    irs[k] = (mwIndex) ir[k] ;
		z[k] = zp[k];
    }
*/
