function [KW, GSB, SB] = calc_kalman_gain2(G, Gt, S, Cov, flag_pinv)
%
% Calcurate Kalman gain matrix
%
% 2012/03/14 M.Fukushima

GSG     = G*S*Gt; 
SB      = GSG + Cov;                 % Sigma_B
if flag_pinv, SB_inv  = pinv( SB );  % Sigam_B^{-1}
else SB_inv  = inv(SB); end
GSB     = Gt*SB_inv;                 % Ga' * Sigma_B^{-1}

% Kalman gain matrix
KW = S*GSB;