function	X = vb_read_vrml_patch(fname)
% Read Patch index frpm XML-file
% 
% IndexedFaceSet {
%    coordIndex [ 
%		2484, 2485, 2465, -1,
%		2465, 2485, 2486, -1,
%			...
%	]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

key.start  = 'IndexedFaceSet';
key.start2 = 'coordIndex';
key.end    = ']';
key.braket = '[';


[Nskip, Nline, Mmax] = vb_read_vrml_line(fname,key,'%d,');

% Read data
% Exclude last number '-1'
%
Mmax = Mmax-1;
X=zeros(Nline,Mmax);

%%%%% DEBUG %%%%
fprintf('Number of patch= %d\n', Nline)
fprintf('Number of Max points in patch = %d\n', Mmax)

fid=fopen(fname);

% Skip lines until data
for n=1:Nskip
    next_line = fgetl(fid);
end

nn = 0;

% Read data
for n=1:Nline
    next_line = fgetl(fid);
	x  = sscanf(next_line,'%d,');

	% Exclude last number '-1'
	Nx = length(x)-1;
	
	if Nx > 0,
		nn = nn + 1;
		id = 1:Nx;
		
		% Add one to index : First index start from 1 instead of 0
		X(n,id) = x(id)' + 1;
		
		% If points are less than Mmax, duplicate first point index
		if Nx < Mmax, 
			X(n,(Nx+1):Mmax) = x(1) + 1; 
		end;
	end
end

fclose(fid);

X = X(1:nn,:);
