function	[V,F,img,X,Y] = vb_read_vivid_file(fname)
% Read VIVID VRML-file
%
% fname : VIVID VRML-file name
%
% V  : 3D-Coordinate   : [Npoint 3]  [mm]
% X  : 2D X-Coordinate : [Npoint 1]  [pixcel]
% Y  : 2D Y-Coordinate : [Npoint 1]  [pixcel]
% F  : Patch index     : [Npatch Nnode]
% img : 2D RGB image   : [NX NY 3]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Read VRML 3D-Coordinate
V  = vb_read_vrml_coordinate3(fname);
F  = vb_read_vrml_patch(fname);

% Read VRML 2D-Coordinate
V2 = vb_read_vrml_coordinate2(fname);

if isempty(V2),
	X=[];Y=[];img=[];
	return;
end;

% Read VRML 2D-Image
[img1,img2,img3] = vb_read_vrml_image(fname);

% img1(Nx, Ny) : R color image 
% img2(Nx, Ny) : G color image 
% img3(Nx, Ny) : B color image 

% Exchange X-Y for MATLAB image plot
img   = cat(3,img1',img2',img3'); 

% Scale 2D-Coordinate to Image size
[NX, NY] = size(img1);

X = V2(:,1)*NX;
Y = V2(:,2)*NY;
