function	vb_meg_sensor_to_mri(megfile)
% Transform MEG sensor position to MRI space
%
% ---- Input file name
% megfile    : MEG position file      (*.megpos.mat)
%
% ---- Input variable in MEG position file
% meg_sensor
%     .pos       : sensor position (on MEG hardware coord)
% trans_mat
%     .meg_to_mri
%
% ---- Output variable for file save
% meg_sensor
%     .mri       : sensor position (on MRI coord)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Load MEG sensor & marker position
%
load(megfile)

% Transform MEG sensor position to MRI coordinate
meg_sensor.mri = vb_affine_trans(meg_sensor.pos , trans_mat.meg_to_mri);

% Save Sensor position in MRI-space
vb_save(megfile ,'meg_sensor');
