function    [Vp, Xp, Yp] = vb_get_proj_point(V,X,Y)
% Get marker 3D coordinate from the projected 2D-image by mouse click
%   Vp = vb_get_ref_point(V,X,Y) 
% --- Input
% V : 3D coordinate
% X : X-coordinate in projected 2D-space
% Y : Y-coordinate in projected 2D-space
% --- output
% Vp : selected 3D point
% Xp : selected X-coordinate
% Yp : selected Y-coordinate
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Input marker position  by mouse click
[xp,yp] = ginput(1);

% Find nearest 3D & 2D-coordinate to the target point
[Vp, Xp, Yp, dmin] = vb_get_3d_point([xp,yp],V,X,Y);


return

% Plot marker on 2D-image
plot3(Xp,Yp,0,mtype1,'MarkerSize',msize1);

% Plot marker on 3D face
subplot(1,2,2)
plot3(Vp(:,1),Vp(:,2),Vp(:,3),mtype2,'MarkerSize',msize2);
