function [len] = vb_samplelist_get_trial_len(sample_list)
% return trial length by sample number
% [usage]
%   [len] = vb_samplelist_get_trial_len(sample_list)
% [input]
%   sample_list : <required> <<struct>> [1 x Ntrial] array of from-to
%               :  .from : start sample number
%               :  .to   : end sample number
% [output]
%   len : number of sample of single trial
% [note]
%
% [history]
%   2008-01-30 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('sample_list', 'var'), sample_list = []; end
[sample_list] = inner_check_arguments(sample_list);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% length of each trials are the same
len = sample_list(1,2) - sample_list(1,1) + 1;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [sample_list] = inner_check_arguments(sample_list)
func_ = mfilename;

if isempty(sample_list)
  error('(%s)sample_list is a required parameter', func_);
end

% if ~isfield(sample_list, 'from') || ~isfield(sample_list, 'to')
%   error('(%s)sample_list is invalid', func_);
% end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
