function vb_msrmnt_remake_for_LF(src_file, dst_file)
% make lightweight meg.mat or eeg.mat file for calculating leadfield
% [usage]
% vb_msrmnt_remake_for_LF(src_file, dst_file)
% [input]
%   src_file : <required> source MEG-MAT or EEG-MAT file
%   dst_file : <optional> output file ['<src_path>/<src_name>.pos.meg(eeg).mat']
% [output]
%   none
% [note]
%   output file can be used as a template file the purpose of which is only
%   updating position
%   @see vb_posfile_remake_datafile.m
%   @see vb_megfile_remake_for_LF.m
%   @see vb_eegfile_remake_for_LF.m
%   Output file is valid only for calculating lead field
% [history]
%   2010-03-05 (Sako) initial version
%   2011-06-01 (Sako) converted return values of vb_load_device to upper case
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('src_file', 'var'), src_file = ''; end
if ~exist('dst_file', 'var'), dst_file = ''; end
[src_file, dst_file] = inner_check_arguments(src_file, dst_file);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
[measurement] = vb_load_device(src_file);
Measurement = upper(measurement);

switch Measurement
  case 'MEG'
    vb_megfile_remake_for_LF(src_file, dst_file);
  case 'EEG'
    vb_eegfile_remake_for_LF(src_file, dst_file);
  otherwise
    error('(%s) unknown Measurement : %s (%s)', ...
      mfilename, Measurement, src_file);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [src_file, dst_file] = inner_check_arguments(src_file, dst_file)
func_ = mfilename;
if isempty(src_file)
  error('(%s) src_file is a required parameter', func_);
end

if exist(src_file, 'file') ~= 2
  error('(%s) cannot find src_file : %s', func_, src_file);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
