function ch_list = vb_msrmnt_get_channel_list(msrmnt_file, active_swt)
% load channel list
% [usage]
%   ch_list = vb_msrmnt_get_channel_list(msrmnt_file, active_swt)
% [input]
%   msrmnt_file : <required> measurement file which includes channel list
%               :    e.g. EEG-MAT (.eeg.mat)  MEG-MAT (.meg.mat)
%    active_swt : <optional> <<boolean>> [false] switch for active channel
%               :   true) return only active channels (EEG)
%               :  false) return all the channels (EEG)
% [output]
%       ch_list : (cell array) list of channel label [N x 1]
% [note]
%   acceptable "Measurement" are :
%     'MEG', 'EEG'
% [history]
%   2007-08-02 (Sako) initial version
%   2008-05-01 (Sako) added active_swt
%   2011-06-01 (Sako) converted return values of vb_load_device to upper case
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('msrmnt_file', 'var'), msrmnt_file = []; end;
if ~exist('active_swt', 'var'), active_swt = []; end
[msrmnt_file, active_swt] = inner_check_arguments(msrmnt_file, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;

ch_list = [];

[measurement] = vb_load_device(msrmnt_file);
Measurement = upper(measurement);

switch Measurement
  case  'MEG'
    ch_list = vb_megfile_get_channel_label_whole(msrmnt_file, active_swt);
    
  case  'EEG'
    ch_list = vb_eegfile_get_channel_label(msrmnt_file, active_swt);
    
  otherwise
    fprintf('(%s)unexpected Measurement type : %s\n', func_, Measurement);
end
% arrange to [N x 1]
ch_list = vb_util_arrange_list(ch_list, 0);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [msrmnt_file, active_swt] = ...
  inner_check_arguments(msrmnt_file, active_swt)
func_ = mfilename;

if isempty(msrmnt_file)
  error('(%s)msrmnt_file is a required parameter', func_);
end

if exist(msrmnt_file, 'file') ~= 2
  error('(%s)cannot find measurement file : %s', func_, msrmnt_file);
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_argument()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
