function [info] = vb_info_set_active_flag(info, active_trial)
% set active flag to each Trial data of MEGinfo or EEGinfo
% [usage]
%   [info] = vb_info_set_active_flag(info, active_trial)
% [input]
%           info : <required> <<struct>> MEGinfo or EEGinfo
%                :  which has Trial field which is struct array ([Ntrial x 1])
%                :  if this does not have Trial field, do nothing
%   active_trial : <optional> [Ntrial x 1 boolean]
%                :  if this is empty or not be specified, all the Trials will
%                :  be set <.Active = true>.
% [output]
%           info : MEGinfo or EEGinfo with updated Trial list
% [note]
%
% [history]
%   2008-04-11 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('active_trial', 'var'), active_trial = []; end
[info, active_trial, err_code] = inner_check_arguments(info, active_trial);

if err_code ~= 0
  % do nothing
  return;
end

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
n_trial = length(info.Trial);
for i_trial = 1:n_trial
  info.Trial(i_trial).Active = active_trial(i_trial);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, active_trial, err_code] = ...
  inner_check_arguments(info, active_trial)
func_ = mfilename;
err_code = 0;

if isempty(info)
  error('(%s)info is a required parameter', func_);
end

if ~isfield(info, 'Trial')
  err_code = 1;
  return;
end

if isempty(active_trial)
  n_trial = length(Trial);
  active_trial = ones(n_trial, 1);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
