function info = vb_info_set_Nrepeat(info, value)
% <<setter>> set Nrepeat value to MEGinfo or EEGinfo
% [usage]
%   info = info_set_trial_number(info, value)
% [input]
%    info : <required> <<struct>> MEGinfo or EEGinfo
%   value : <optional> number of trial [0]
% [output]
%    info : updated info
% [note]
%   Nrepeat field keeps the number of all the trials
% [history]
%   2008-04-15 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('value', 'var'), value = []; end
[info, value] = inner_check_arguments(info, value);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
info.Nrepeat = value;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, value] = inner_check_arguments(info, value)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end

if isempty(value)
  value = 0;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
