function [ch_info] = vb_info_make_channel_info(info, measurement)
% make channel info data from MEGinfo or EEGinfo which has not ChannelInfo field
% [usage]
%   [ch_info] = vb_info_make_channel_info(info, measurement)
% [input]
%   info : <required> <<struct>> MEGinfo or EEGinfo
%   measurement : <required> 'MEG' or 'EEG'
%               :  case-insensitive
% [output]
%   ch_info : <<struct>> fields are as follows:
%           :  .Active <-- info.ActiveChannel
%           :  .Name   <-- MEGinfo.MEGch_name, EEGinfo.ChannelName
%           :  .ID     <-- MEGinfo.MEGch_id,   EEGinfo.ChannelID
%           :  .Type   <-- []
% [note]
%
% [history]
%   2009-08-19 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('measurement', 'var'), measurement = ''; end
[info, measurement] = inner_check_arguments(info, measurement);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% --- initialize
ch_info.Active = [];
ch_info.Name   = [];
ch_info.ID     = [];
ch_info.Type   = [];

if isfield(info, 'ActiveChannel')
  ch_info.Active = info.ActiveChannel;
end

switch measurement
  case 'MEG'
    if isfield(info, 'MEGch_name')
      ch_info.Name = info.MEGch_name;
    end
    
    if isfield(info, 'MEGch_id')
      ch_info.ID = info.MEGch_id;
    end

  case 'EEG'
    if isfield(info, 'ChannelName')
      ch_info.Name = info.ChannelName;
    end
    
    if isfield(info, 'ChannelID')
      ch_info.ID = info.ChannelID;
    end
  otherwise
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, measurement] = inner_check_arguments(info, measurement)
func_ = mfilename;

if isempty(info)
  error('(%s) info is a required parameter', func_);
end

if isempty(measurement)
  error('(%s) measurement is a required parameter', func_);
end

measurement = upper(measurement);
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
