function sampling_frequency = vb_info_get_sampling_frequency(info)
% one of infor getters. get sampling frequency from information struct
% [usage]
%   sampling_frequency = vb_info_get_sampling_frequency(info)
% [input]
%                 info : <required> <<struct>> information struct
%                      :  EEGinfo or MEGinfo or other (unexpected)
% [output]
%   sampling_frequency : sampling frequency [Hz]
% [note]
%   acceptable 'info' are :
%   'MEGinfo', 'EEGinfo'
% [history]
%   2008-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var') info = []; end;
info = inner_check_arguments(info);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;
sampling_frequency = [];

my_measurement = vb_info_get_measurement(info);

switch my_measurement
  case  'MEG'
    sampling_frequency = vb_meginfo_get_sampling_frequency(info);
  case  'EEG'
    sampling_frequency = vb_eeginfo_get_sampling_frequency(info);
  otherwise
    error('(%s)unexpected Measurement type : %s', func_, my_measurement);
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check arguments()
%
function info = inner_check_arguments(info)
func_ = mfilename;

if isempty(info)
  error('(%s)info is a required parameter', func_);
end
%
% --- inner_check arguments()

%%% END OF FILE %%%
