function [pretrigger] = vb_info_get_pre_trigger(info)
% return pre-trigger from current info struct
% [usage]
%   [pretrigger] = vb_info_get_pre_trigger(info)
% [input]
%          info : <required> <<struct>> EEGinfo or MEGinfo
% [output]
%   pretrigger : pre-trigger value of current info struct
% [note]
%   @see vb_meginfo_get_pre_trigger.m
%   @see vb_eeginfo_get_pre_trigger.m
% [hisotory]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var') info = []; end
[info] = inner_check_arguments(info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;

my_measurement = vb_info_get_measurement(info);

switch my_measurement
  case  'EEG'
    pretrigger = vb_eeginfo_get_pre_trigger(info);
  case  'MEG'
    pretrigger = vb_meginfo_get_pre_trigger(info);
  otherwise
    error('(%s)unexpected measurement : %s', func_, my_measurement);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info] = inner_check_arguments(info)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
