function ch_label = vb_info_get_channel_label_by_type(info, ch_type)
% return channel label list specified by channel type (integer)
% [usage]
%   ch_label = vb_info_get_channel_label_by_type(info, ch_type)
% [input]
%      info : <required> MEGinfo or EEGinfo
%   ch_type : <optional> channel type [1]
% [output]
%   ch_label : extracted channel label list {Nchannel x 1}
% [note]
%   @see vb_info_get_channel_info.m
% [history]
%   2009-07-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('ch_type', 'var'), ch_type = []; end
[info, ch_type] = inner_check_arguments(info, ch_type);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% --- get info of all channels
ch_info = vb_info_get_channel_info(info, 2);

if isempty(ch_info) || ~isfield(ch_info, 'Type') || isempty(ch_info.Type)
  fprintf('(%s) ChannelInfo of this info does not have type list\n', ...
    mfilename);
  ch_label = {};
  return;
end

if ~isfield(ch_info, 'Name') || isempty(ch_info.Name)
  fprintf('(%s) ChannelInfo of this info does not have Name list\n', ...
    mfilename);
  ch_label = {};
  return;
end

ch_label = ch_info.Name(ch_info.Type == ch_type);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, ch_type] = inner_check_arguments(info, ch_type)
func_ = mfilename;

if isempty(info)
  error('(%s) info is a required parameter', func_);
end

if isempty(ch_type)
  ch_type = 1;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
