function [idx_list, result] = vb_info_get_active_trial_index(info)
% return active trial index list
% [usage]
%   [idx_list, result] = vb_info_get_active_trial_index(info)
% [input]
%       info : <required> <<struct>> MEGinfo or EEGinfo
% [output]
%   idx_list : [N_activeCh x 1] active trial index list
%     result : <<integer>> error code
%            :  0) success
%            :  1) error - bad info
% [note]
%
% [history]
%   2008-06-05 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
[info, result] = inner_check_arguments(info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if result ~= 0
  idx_list = [];
  return;
end

if vb_info_active_trial_is_valid(info)
  active_list = vb_info_get_active_trial(info);
  idx_list = find(active_list);
  return;
end

% --- no ActiveTrial field in info
idx_list = 1:vb_info_get_Nrepeat(info);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, result] = inner_check_arguments(info)
result = 0;
if isempty(info)
  fprintf('(%s)info is a required parameter\n', mfilename);
  result = 1;
  return;
end
return;
%
% --- end of inner_check_arguments()
% 
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
