function [info, result] = vb_info_adjust_trial(info, aim_code)
% adjust trial according to Trial field of MEGinfo or EEGinfo
% [usage]
%   [info, result] = vb_info_adjust_trial(info, aim_code)
% [input]
%       info : <required> <<struct>> MEGinfo or EEGinfo
%   aim_code : <optional> [1]
%            :  0) update Nrepeat only
%            :  1) update Nrepeat and Trial.Active
% [output]
%     info : updated MEGinfo or EEGinfo
%   result : <<integer>> error code
%          :  0) success
%          :  1) error - bad info
% [note]
%    .Nrepeat
%    .ActiveTrial
% [history]
%   2008-04-23 (Sako) initial version
%   2008-06-10 (Sako) modified to set ActiveTrial correctly
%   2009-07-13 (Sako) added aim_code
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('aim_code', 'var'), aim_code = []; end
[info, aim_code, result] = inner_check_arguments(info, aim_code);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if result ~= 0
  return;
end

cur_trial = vb_info_get_trial_list(info);
N_trial = length(cur_trial);
info = vb_info_set_Nrepeat(info, N_trial);

if aim_code == 0
  return;
end

active_trial = ones(N_trial,1);

% --- new format
if isfield(info, 'Trial')
  for i_tr = 1:N_trial
    if isfield(info.Trial(i_tr), 'Active')
      active_trial(i_tr) = info.Trial(i_tr).Active;
    else
      active_trial(i_tr) = 1;
    end
  end
end
info = vb_info_set_active_trial(info, active_trial);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, aim_code, result] = inner_check_arguments(info, aim_code)
func_ = mfilename;
result = 0;

if isempty(info)
  fprintf('(%s)info is a required parameter\n', func_);
  result = 1;
  return;
end

if isempty(aim_code)
  aim_code = 1;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
