function [result] = vb_info_active_channel_is_valid(info)
% check whether active channel field is valid or not
% [usage]
%   [result] = vb_info_active_channel_is_valid(info)
% [input]
%     info : <required> <<struct>> MEGinfo or EEGinfo
% [output]
%   result : <<boolean>>
%          :   true) valid
%          :  false) invalid
% [note]
%   for now, MEGinfo and EEGinfo has the same field name for active channel
%   invalid conditions are as follows.
%    * There is not the appropriate field
%    * Active channel field is empty
%    * The length of active channel is different from the number of sensor
% [history]
%   2008-04-11 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
[info] = inner_check_arguments(info);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
result = false;
if ~isfield(info, 'ActiveChannel') || isempty(info.ActiveChannel)
  return;
end

Nchannel = vb_info_get_Nchannel(info);
len_active = length(info.ActiveChannel);
if Nchannel ~= len_active
%   fprintf('(%s)numbers are different Nchannel(%d) and ActiveChannel(%d)\n', ...
%     mfilename, Nchannel, len_active);
  return;
end

result = true;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info] = inner_check_arguments(info)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
