function	[ix_trial,trig,cond_id,status_val,status_out] = ...
			vb_get_trial_time_index(status,parm)
% get trial time index from status channel
%
%    [ix_trial,trig,cond_id,status_val,status_out] = ...
%          vb_get_trial_time_index(status,parm)
% --- Inout
%  parm.Pretrigger_ms : Pretrigger period   [msec]
%  parm.Posttrigger_ms: Posttrigger period  [msec]
%  parm.condition : string describing condition [string or cell array]
%  parm.status_level : status level (ratio for max) for onset [Ncondition x 1]
%  parm.fsamp     : Sample Frequency [Hz]
% --- Output
% trig(n)       : Onset time index for n-th trial 
% cond_id(n)    : Condition ID for n-th trial 
% ix_trial(:,n) : Time index for n-th trial   [Tperiod x Ntrial]
%                 Tperiod : # of time sample in one trial
%                 Ntrial  : # of trials
% status_val(m) = parm.status_level(m) * max(status)
% status_out : masked status signal if mask flag is specified
%
% 2009-6-11 Masa-aki Sato
% 2011-12-11 Masa-aki Sato 
%    Added 'status_out'
% 2012-1-8  Masa-aki Sato 
%   Added 'multi' channel bit pattern
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Pre/Post period in msec
Pretrigger_ms  = parm.Pretrigger_ms ; % [msec]
Posttrigger_ms = parm.Posttrigger_ms; % [msec]

% Sample Frequency [Hz]
fsamp  = parm.fsamp;
%fprintf('Sampleing Frequency: %6.1f [Hz]\n',fsamp)

% Sample number for Pre/Post period
Pretrigger  = ceil(Pretrigger_ms *(fsamp/1000));
Posttrigger = ceil(Posttrigger_ms*(fsamp/1000));

status_level  = parm.status_level ;

if isempty(status_level)
	Ncond = 1;
else
	Ncond = length(status_level);
end

[Nch ,T] = size(status);
status_out = zeros(Nch ,T);

if (Ncond ~= Nch ),
	if (Ncond > 1) && (Nch > 1),
		error('Condition number and Status ch number mismatch!!')
	end
end

if	strcmp( lower(parm.trig_type), 'multi')==1,
	[ix_trg,status_val,status_out] = ...
		vb_get_trigger_multi(status,status_level,parm);
	
	Ntrg   = length(ix_trg);
	ix_trg = {ix_trg};
	Ncond  = 1;
	fprintf('# of trials = %d\n',Ntrg)
else
	
	ix_trg = cell(1,Ncond);
	Ntrg = zeros(Ncond,1);
	status_val = zeros(Ncond,1);
	
	% extract event start from status signal
	for n = 1:Ncond
		if (n > 1) && (Nch == 1),
			y = status;
		else
			y = status(n,:);
		end
	    status_offset = 0;
	    status_mask   = [];
	    if isfield(parm,'status_offset')
	        status_offset = parm.status_offset;
	    end
	    if isfield(parm,'status_mask')
			% mask irrelevant bit
	        status_mask = parm.status_mask;
	    end
	    y = vb_get_status_mask(y, status_mask, status_offset);
		
		if isempty(status_level)
			level = [];
		else
			level = status_level(n);
		end
	
		[ix_trg{n},status_val(n),ya] = vb_get_trigger_event(y,level,parm);
		
		if (n > 1) && (Nch == 1),
			status_out = ya;
		else
			status_out(n,:) = ya;
		end
	
		Ntrg(n) = length(ix_trg{n});
		fprintf('# of trials = %d (Cond: %d)\n',Ntrg(n),n)
	end
end

if sum(Ntrg)==0
	fprintf('No epoch is found\n\n')
	ix_trial = [];
	cond_id = [];
	trig = [];
	return
end

% trigger index and condition flag for all epochs
Nall = sum(Ntrg);
cond_id = zeros(1,Nall);
trig = zeros(1,Nall);
Nst  = 0;

% Combine all trigger time index
for n = 1:Ncond
	ix = (1:Ntrg(n)) + Nst;
	trig(ix) = round(ix_trg{n})';
	cond_id(ix) = n;
	Nst = Nst + Ntrg(n);
end

% trig(n) : n-th triger time
% cond_id(n) : corresponding condition label

%--- sort triger timing according to temporal order
[trig, jx] = sort(trig);
cond_id = cond_id(jx);

% Time index for one trial
ix = (-Pretrigger:Posttrigger)';
Tp = length(ix);

% Time index for all trials extracted from 'trig'
ix_trial = repmat(ix,[1 Nall]) + repmat(trig,[Tp 1]);

% Check index range
ix_trial = max(ix_trial,1);
trig     = max(trig    ,1);
ix_trial = min(ix_trial,T);
trig     = min(trig    ,T);
