function [ch_name] = vb_ykgwfile_load_channel_name_extra(ykgwfile, type_id)
% load extra channel name from yokogawa file
% [usage]
%   [ch_name] = vb_ykgwfile_load_channel_name_extra(ykgwfile, type_id)
% [input]
%   ykgwfile : <required> <<file>> YOKOGAWA file (*.con | *.ave | *.raw)
%    type_id : <optional> <<integer>> type id []
%            :  the case of YOKOGAWA-MEG, as follows
%            :    0) Null Channel
%            :   -1) Trigger Channel
%            :   -2) Eeg Channel
%            :   -3) Ecg Channel
%            :   -4) Etc Channel
%            :  if this is empty, return names of all channel
%   ch_name : [N x 1] name (number) list of acceptable channels
% [note]
%   @see vb_ykgwfile_load_extra_channel_info.m
%   @see vb_meginfo_get_channel_name_extra.m
% [history]
%   2008-02-05 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('ykgwfile', 'var'), ykgwfile = []; end
if ~exist('type_id', 'var'), type_id = []; end
[ykgwfile, type_id] = inner_check_arguments(ykgwfile, type_id);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% get temporary MEGinfo
meg_info = vb_ykgwfile_load_extra_channel_info(ykgwfile, []);
ch_name = vb_meginfo_get_channel_name_extra(meg_info, type_id);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [ykgwfile, type_id] = inner_check_arguments(ykgwfile, type_id)
func_ = mfilename;
if isempty(ykgwfile)
  error('(%s)ykgwfile is a required parameter', func_);
end

if exist(ykgwfile, 'file') ~= 2
  error('(%s)cannot find ykgwfile : %s', func_, ykgwfile);
end

if isempty(type_id)
  % require no action
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
