function [megdata, extdata, refdata, meg_info] = ...
  vb_meg_yokogawa_separate_data(orgdata, meg_info)
% separate original data to MEG data, EXTRA data and REFMG data
% [usage]
%   [megdata, exdata, meg_info] = ...
%      vb_meg_yokogawa_separate_data(megdata, meg_info)
% [input]
%    orgdata : <required> acquired data which include MEG, EXTRA, REFMG data
%   meg_info : <required> <<struct>> MEGinfo
% [output]
%    megdata : MEG data which was acquired by MEG channels
%    extdata : extra data which was acquired by EXTRA channels
%    refdata : reference magnetometer data
%   meg_info : <<struct>> updated MEG
% [note]
%   acquired data (:,1,:) is sample number
% [history]
%   2007-07-03 (Sako) initial version
%   2008-02-08 (Sako) modified thoroughly according to new specification
%   2009-07-14 (Sako) modified to arrange by the order of imported channels
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('orgdata', 'var'), orgdata = []; end
if ~exist('meg_info', 'var'), meg_info = []; end
[orgdata, meg_info] = inner_check_arguments(orgdata, meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isempty(orgdata)
  return;
end

org_label = orgdata(:,1,1);

meg_ch_label_str = vb_meginfo_get_channel_label_meg(meg_info);
meg_ch_label = str2double(meg_ch_label_str);
[tmp_idx, meg_ch_idx] = vb_util_get_index(meg_ch_label, org_label);
megdata = orgdata(meg_ch_idx, 2:end, :);

ext_ch_label_str = vb_meginfo_get_channel_label_extra(meg_info);
ext_ch_label = str2double(ext_ch_label_str);
[tmp_idx, ext_ch_idx] = vb_util_get_index(ext_ch_label, org_label);
extdata = orgdata(ext_ch_idx, 2:end, :);

ref_ch_label_str = vb_meginfo_get_channel_label_refmg(meg_info);
ref_ch_label = str2double(ref_ch_label_str);
[tmp_idx, ref_ch_idx] = vb_util_get_index(ref_ch_label, org_label);
refdata = orgdata(ref_ch_idx, 2:end, :);

% added field to meginfo
meg_info.MEGch_id = meg_ch_idx;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [bexp, meg_info] = inner_check_arguments(bexp, meg_info)
func_ = mfilename;

if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end

if isempty(bexp)
  % require no action
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
