function [meginfo, new_ref_pick, new_ref_Qpick] = ...
  vb_meginfo_solve_refmg_channel(meginfo, ref_pick, ref_Qpick, ch_name)
% update refmg channel data by ch_name without change extra channels
% [usage]
%   [meginfo, new_ref_pick, new_ref_Qpick] = ...
%       vb_meginfo_solve_refmg_channel(meginfo, ref_pick, ref_Qpick, ch_name)
% [input]
%     meginfo : <required> <<struct>> MEGinfo
%    ref_pick : <required> [Nchannel_ref x 3] coordinates of refmg channels
%   ref_Qpick : <required> [Nchannel_ref x 3] normal vectors of refmg channels
%     ch_name : <optional> {Nchannel x 1 cell} channel name list ['']
%             :  if this is empty, do nothing
% [output]
%         meginfo : MEGinfo after updating sensor_weight_ref is updated
%    new_ref_pick : [Nchannel_ref_new x 3] updated ref_pick
%   new_ref_Qpick : [Nchannel_ref_new x 3] updated ref_Qpick
% [note]
%   @see vb_megfile_make_new_megfile.m
% [history]
%   2009-07-07 (Sako) initial version
%   2011-07-21 (Sako) modified how to deal with sensor_weight_ref
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('ref_pick', 'var'), ref_pick = []; end
if ~exist('ref_Qpick', 'var'), ref_Qpick = []; end
if ~exist('ch_name', 'var'), ch_name = ''; end
[meginfo, ref_pick, ref_Qpick, ch_name] = ...
  inner_check_arguments(meginfo, ref_pick, ref_Qpick, ch_name);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(meginfo, 'ExtraChannelInfo') || isempty(ch_name)
  % do nothing
  return;
end

ext_ch = vb_meginfo_get_channel_label_extra(meginfo, false);

% ----- arrange list
ext_ch = vb_util_arrange_list(ext_ch, 0);
ch_name = vb_util_arrange_list(ch_name, 0);
new_ext_ch_name = [ext_ch; ch_name];

base_ch_label = meginfo.ExtraChannelInfo.Channel_name;
              
if ~isempty(base_ch_label)
  [idx] = vb_util_get_index(base_ch_label, new_ext_ch_name);

  ex_info = meginfo.ExtraChannelInfo;

  % information for reference channels
  ref_ch = vb_meginfo_get_channel_label_refmg(meginfo);
  ref_idx = vb_util_get_index(ref_ch, ch_name);
  
  new_ref_pick = ref_pick(ref_idx, :);
  new_ref_Qpick = ref_Qpick(ref_idx, :);
  
  if vb_meginfo_sensor_weight_refmg_exist(meginfo)
    org_weight = vb_meginfo_get_sensor_weight_refmg(meginfo);
    meginfo = ...
      vb_meginfo_set_sensor_weight_refmg(meginfo, org_weight(ref_idx,ref_idx));
  end
  
  % --- information for all extra channels
  meginfo.ExtraChannelInfo.Channel_active = ex_info.Channel_active(idx);
  meginfo.ExtraChannelInfo.Channel_name = ex_info.Channel_name(idx);
  meginfo.ExtraChannelInfo.Channel_type = ex_info.Channel_type(idx);
  meginfo.ExtraChannelInfo.Channel_id = ex_info.Channel_id(idx);
  
else
  meginfo.ExtraChannelInfo.Channel_active = [];
  meginfo.ExtraChannelInfo.Channel_name = [];
  meginfo.ExtraChannelInfo.Channel_type = [];
  meginfo.ExtraChannelInfo.Channel_id = [];
  
  meginfo = vb_meginfo_set_sensor_weight_refmg(meginfo, []);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, ref_pick, ref_Qpick, ch_name] = ...
  inner_check_arguments(meginfo, ref_pick, ref_Qpick, ch_name)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if isempty(ref_pick)
  % require no action
end

if isempty(ref_Qpick)
  % require no action
end

if ~isempty(ch_name) && ~iscell(ch_name)
  ch_name = {ch_name};
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
