function [meginfo, new_ref_pick, new_ref_Qpick] = ...
  vb_meginfo_solve_extra_channel(meginfo, ref_pick, ref_Qpick, ch_name)
% solve MEGinfo.ExtraChannelInfo data by ch_name which is the list of new data
%
% [usage]
%   [meginfo, ref_pick, ref_Qpick] = ...
%     vb_meginfo_solve_extra_channel(meginfo, ref_pick, ref_Qpick, ch_name)
%
% [input]
%     meginfo : <required> <<struct>> MEGinfo
%    ref_pick : <required> [Nchannel_ref x 3] coordinates of refmg channels
%   ref_Qpick : <required> [Nchannel_ref x 3] normal vectors of refmg channels
%     ch_name : <optional> {Nchannel x 1 cell} channel name list ['']
%             :  if this is empty, do nothing
%
% [output]
%         meginfo : MEGinfo after updating ExtraChannelInfo and
%                 : sensor_weight_ref
%   new_ref_pick  : [Nchannel_ref_new x 3] updated ref_pick
%   new_ref_Qpick : [Nchannel_ref_new x 3] updated ref_Qpick
%
% [note]
%   See also
%     vb_megfile_make_new_megfile
%
% [history]
%   2008-02-21 (Sako) initial version
%   2009-07-08 (Sako) supported refmg channels
%   2011-07-21 (Sako) modified sensor_weight_ref according to the new format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('ref_pick', 'var'), ref_pick = []; end
if ~exist('ref_Qpick', 'var'), ref_Qpick = []; end
if ~exist('ch_name', 'var'), ch_name = ''; end
[meginfo, ref_pick, ref_Qpick, ch_name] = ...
  inner_check_arguments(meginfo, ref_pick, ref_Qpick, ch_name);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%

% --- sensor coordinates of refmg
new_ref_pick = [];
new_ref_Qpick = [];

% --- current label list
refmg_ch_label = vb_meginfo_get_channel_label_refmg(meginfo);
allex_ch_label = vb_meginfo_get_channel_label_extra(meginfo, false, true);

if ~isfield(meginfo, 'ExtraChannelInfo') ...
    || isempty(ch_name) ...
    || isempty(allex_ch_label)
  
  % --- MEGinfo.ExtraChannelInfo
  ex_info.Channel_active = [];
  ex_info.Channel_name = {};
  ex_info.Channel_type = [];
  ex_info.Channel_id = [];
  meginfo.ExtraChannelInfo = ex_info;
  
  % --- other fields of MEGinfo
  meginfo = vb_meginfo_set_sensor_weight_refmg(meginfo, []);
  return;
end

% get extra channel list and refmg channel list
% base_ch_label = meginfo.ExtraChannelInfo.Channel_name;
% --- ExtraChannelInfo
if ~isempty(allex_ch_label) && ~isempty(ch_name)
  [idx] = vb_util_get_index(allex_ch_label, ch_name);

  ex_info = meginfo.ExtraChannelInfo;

  meginfo.ExtraChannelInfo.Channel_active = ex_info.Channel_active(idx);
  meginfo.ExtraChannelInfo.Channel_name = ex_info.Channel_name(idx);
  meginfo.ExtraChannelInfo.Channel_type = ex_info.Channel_type(idx);
  meginfo.ExtraChannelInfo.Channel_id = ex_info.Channel_id(idx);
  
  % --- refmg channel information
  [idx_ref] = vb_util_get_index(refmg_ch_label, ch_name);
  if ~isempty(ref_pick)
    new_ref_pick = ref_pick(idx_ref, :);
  end
  
  if ~isempty(ref_Qpick)
    new_ref_Qpick = ref_Qpick(idx_ref, :);
  end

  if vb_meginfo_sensor_weight_refmg_exist(meginfo)
    reflen = length(idx_ref);
    meginfo = vb_meginfo_init_sensor_weight_refmg(meginfo, reflen);
  end
  
else
  meginfo.ExtraChannelInfo.Channel_active = [];
  meginfo.ExtraChannelInfo.Channel_name = [];
  meginfo.ExtraChannelInfo.Channel_type = [];
  meginfo.ExtraChannelInfo.Channel_id = [];
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, ref_pick, ref_Qpick, ch_name] = ...
  inner_check_arguments(meginfo, ref_pick, ref_Qpick, ch_name)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if isempty(ref_pick)
  % require no action
end

if isempty(ref_Qpick)
  % require no action
end

if ~isempty(ch_name) && ~iscell(ch_name)
  ch_name = {ch_name};
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
