function [meginfo] = vb_meginfo_set_precision(meginfo, prec)
% return precision of binary data
% [usage]
%   [meginfo] = vb_meginfo_set_precision(meginfo, prec)
% [input]
%   meginfo : <required> <<struct>> MEG information
%      prec : <optional> <<string>> precision ['']
%           :  default value is empty string
% [output]
%   meginfo : newly updated MEGinfo struct
% [note]
%   precision is used by fread or fwrite
% [history]
%   2007-06-25 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var') meginfo = []; end
if ~exist('prec', 'var') prec = ''; end
[meginfo, prec] = inner_check_arguments(meginfo, prec);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meginfo.saveman.precision = prec;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, prec] = inner_check_arguments(meginfo, prec)

func_ = 'vb_meginfo_set_precision';

if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
