function [meg_info] = vb_meginfo_set_data_bit_len(meg_info, bit_len)
% MEGinfo setter for data bit length
% [usage]
%   [meg_info] = vb_meginfo_set_data_bit_len(meg_info, bit_len)
% [input]
%   meg_info : <required> <<struct>> MEG information
%    bit_len : <optional> <<file>> data bit length []
%            : e.g. 12 or 16
% [output]
%   meg_info : updated MEG information struct
%            :  the data is stored in 'acq_info' as 'data_bit_len' field
% [note]
%   The new standard format was defined. (2011-05-26)
% [history]
%   2007-06-12 (Sako) initial version
%   2011-05-26 (Sako) modified according to the new data format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('bit_len', 'var'), bit_len = []; end
[meg_info, bit_len] = inner_check_arguments(meg_info, bit_len);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meg_info.device_info.acq_info.data_bit_len = bit_len;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info, bit_len] = inner_check_arguments(meg_info, bit_len)
func_ = mfilename;

if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
