function [bit_len] = vb_meginfo_load_data_bit_len(meg_info)
% load data bit length from yokogawa file
%
% [usage]
%   [bit_len] = vb_meginfo_load_data_bit_len(meg_info)
%
% [input]
%   meg_info : <required> <<struct>> MEG header information
%
% [output]
%    bit_len : loaded data bit length
%
% [note]
%   if given MEGinfo does not have acquisition file field, return empty
% 
%   See also:
%     getYkgwHdrCalib
%
% [history]
%   2007-06-12 (Sako) initial version
%   2007-08-22 (Sako) modified name of yokogawa_lib function
%   2008-06-16 (Sako) modified adding fclose
%   2011-06-23 (Sako) modified to use the new YOKOGAWA library
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
[meg_info] = inner_check_arguments(meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%

% --- CONSTANTS
acq_file = vb_meginfo_get_acqfile(meg_info);

if isempty(acq_file)
  bit_len = [];
  return;
end

calib = getYkgwHdrCalib(acq_file);
bit_len = calib.ad.bit;

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info] = inner_check_arguments(meg_info)

func_ = mfilename;

if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
